@echo off

rem ****************************************************
rem **    GTAP ELECTRICITY DISAGGREGATION VERSION 9   **
rem ****************************************************
rem ** Created by Jeffrey C. Peters, jffptrs@gmail.com **
rem ****************************************************

rem ** This takes in GTAP basedata.har and sets.har for 2011 and returns electricity expanded database
rem ** Requires GTAP, GEMPACK, and GAMS licenses
rem ** Run time ~ 15 minutes

rem ***************
rem **    2011   **
rem ***************

rem ** Create new sets using SplitCom-based .exe files:

rem ** split1 creates GEMPACK sets for splitting data (e.g. expanded TRAD_COMM, PROD_COMM)
		tablo -pgs split1
		gemsim -cmf split1.cmf

rem ** gtp2norm creates "normalized GTAP data" converting the numberous headers in gsddat.har to a NATIONAL and TRADE matrices
		tablo -pgs gtp2norm
		gemsim -cmf gtp2norm.cmf

rem ** expwgt simply creates a wieghting porportion file required for splitflo to run (required junk file -- artifact of using SplitCom files)
		tablo -pgs expwgt
		gemsim -cmf expwgt.cmf

rem ** splitflo creates "normalized GTAP data" with the expanded sectors
		tablo -pgs splitflo
		gemsim -cmf splitflo.cmf

rem ** har2gdx converts the .har files from the previous lines to .gdx for GAMS
		gams har2gdx.gms

rem ** This GAMS file follows the methodology outlined in Section 3 of : The GTAP-Power Database: Disaggregating the Electricity Sector in the GTAP Database.
		gams ely_disagg_erp_2011.gms

rem ** Convert normalized disagg (national and trade) to GTAP format and GTAPView

rem ** norm2gtpely converts the "normalized GTAP data" manipulated in GAMS back to the headers found in the standard gsddat.har
		tablo -pgs norm2gtpely
		gemsim -cmf norm2gtpely.cmf

rem ** gtapview creates the expanded gtapview.har
		tablo -pgs gtapview
		gemsim -cmf gtapview.cmf

rem ** emiss_vole creates the expanded gsdemiss.har (carbon emissions) and gsdvole.har (energy volumes)
		tablo -pgs emiss_vole
		gemsim -cmf emiss_vole.cmf


rem ***************
rem **   DONE    **
rem ***************


 