$title	Read GTAP8 Basedata and Replicate the Benchmark in MPSGE

* The following pre-assignment for ds will be used in a $gdxin command in gtap8data.gms
*$if not set ds $set ds iea_001
$if not set ds $set ds 2r3s2f

* Sets, parameters declarations and assignments are done in gtap8data.gms (YHC: 20120614)
$include ..\build\gtap8data

set c(g) private consumption /c/;
parameters	
esub(g)		Top-level elasticity indemand /C 1/
vcm(i,c,r)      Tax included Armington good i for private consumption;
vcm(i,c,r) = vdfm(i,c,r)*(1+rtfd0(i,c,r))+vifm(i,c,r)*(1+rtfi0(i,c,r));

$ontext
$model:gtap8

$sectors:
	y(g,r)$vom(g,r)		          ! Supply
	m(i,r)$vim(i,r)		          ! Imports
	yt(j)$vtw(j)		          ! Transportation services
	ft(f,r)$(sf(f) and evom(f,r))	  ! Specific factor transformation
        yc(i,c,r)$vcm(i,c,r)              ! Private consumption by commodity


$commodities:
	p(g,r)$vom(g,r)		          ! Domestic output price	 			 
	pm(j,r)$vim(j,r)		  ! Import price		 		 
	pt(j)$vtw(j)			  ! Transportation services		 
	pf(f,r)$evom(f,r)	          ! Primary factors rent
	ps(f,g,r)$(sf(f) and vfm(f,g,r))  ! Sector-specific primary factors
        pc(i,c,r)$vcm(i,c,r)              ! Private consumption price

$consumers:
	ra(r)			          ! Representative agent

$report:
        v:qvdfm(i,c,r)  i:p(i,r)      	prod:y(c,r)
        v:qvifm(i,c,r)  i:pm(i,r)      	prod:y(c,r)
      

$prod:y(g,r)$(not c(g) and vom(g,r))	s:esub(g)       i.tl:esubd(i)  va:esubva(g)
	o:p(g,r)	q:vom(g,r)	a:ra(r)  t:rto(g,r)
	i:p(i,r)	q:vdfm(i,g,r)	p:(1+rtfd0(i,g,r))   i.tl:  a:ra(r)  t:rtfd(i,g,r)
	i:pm(i,r)	q:vifm(i,g,r)	p:(1+rtfi0(i,g,r))   i.tl:  a:ra(r)  t:rtfi(i,g,r)
	i:ps(sf,g,r)	q:vfm(sf,g,r)	p:(1+rtf0(sf,g,r))   va:    a:ra(r)  t:rtf(sf,g,r)
	i:pf(mf,r)	q:vfm(mf,g,r)	p:(1+rtf0(mf,g,r))   va:    a:ra(r)  t:rtf(mf,g,r)

$prod:yc(i,c,r)$vcm(i,c,r) s:esubd(i)
        o:pc(i,c,r)     q:vcm(i,c,r)                         a:ra(r)  t:rto(c,r)
        i:p(i,r)        q:vdfm(i,c,r)	p:(1+rtfd0(i,c,r))   a:ra(r)  t:rtfd(i,c,r)
        i:pm(i,r)       q:vifm(i,c,r)	p:(1+rtfi0(i,c,r))   a:ra(r)  t:rtfi(i,c,r)

$prod:y(g,r)$(c(g) and vom(g,r))	s:esub(g)       i.tl:esubd(i)  va:esubva(g)
	o:p(g,r)	q:vom(g,r)	a:ra(r)  t:rto(g,r)
        i:pc(i,c,r)     q:vcm(i,c,r)

*$prod:y(g,r)$(c(g) and vom(g,r))	s:esub(g)       i.tl:esubd(i)  va:esubva(g)
*	o:p(g,r)	q:vom(g,r)	a:ra(r)  t:rto(g,r)
*	i:p(i,r)	q:vdfm(i,g,r)	p:(1+rtfd0(i,g,r))   i.tl:  a:ra(r)  t:rtfd(i,g,r)
*	i:pm(i,r)	q:vifm(i,g,r)	p:(1+rtfi0(i,g,r))   i.tl:  a:ra(r)  t:rtfi(i,g,r)

$prod:yt(j)$vtw(j)      s:1
	o:pt(j)		q:vtw(j)
	i:p(j,r)	q:vst(j,r)

$prod:m(i,r)$vim(i,r)	s:esubm(i)      s.tl:0
	o:pm(i,r)	q:vim(i,r)
	i:p(i,s)	q:vxmd(i,s,r)	p:pvxmd(i,s,r)       s.tl:  a:ra(s)  t:(-rtxs(i,s,r))  a:ra(r)  t:(rtms(i,s,r)*(1-rtxs(i,s,r)))
	i:pt(j)#(s)	q:vtwr(j,i,s,r) p:pvtwr(i,s,r)       s.tl:  a:ra(r)  t:rtms(i,s,r)

$prod:ft(sf,r)$evom(sf,r)  t:etrae(sf)
	o:ps(sf,j,r)	q:vfm(sf,j,r)
	i:pf(sf,r)	q:evom(sf,r)

$demand:ra(r)
	d:p("c",r)	q:vom("c",r)
	e:p("c",rnum)	q:vb(r)
	e:p("g",r)	q:(-vom("g",r))
	e:p("i",r)	q:(-vom("i",r))
	e:pf(f,r)	q:evom(f,r)

$offtext
$sysinclude mpsgeset gtap8

*evom(f,r) = evom(f,r)*5;
*P.FX("c","usa") = 1;
PF.FX("primary","usa") = 1;
gtap8.workspace = 128;
gtap8.iterlim = 0;
gtap8.optfile = 1;
$include gtap8.gen
solve gtap8 using mcp;
execute_unload "mrtmge_ces_ref_ds=%ds%.gdx";

*rtfd("p_c",c,"usa") = rtfd("p_c",c,"usa")*1.5;
*rtfi("p_c",c,"usa") = rtfi("p_c",c,"usa")*1.5;

*rtfd("roil",c,"usa") = rtfd0("roil",c,"usa")*1.25;
*rtfi("roil",c,"usa") = rtfi0("roil",c,"usa")*1.25;

parameter rto0;
rto0(j,r) = rto(j,r);
*rto("roil","usa") = rto0("roil","usa")*2;

*rtfd("food",c,"usa") = rtfd0("food",c,"usa")*0.5;
*rtfi("food",c,"usa") = rtfi0("food",c,"usa")*0.5;

*vdfm("food",c,r) = vdfm("food",c,r)*1.00001;
*vifm("food",c,r) = vifm("food",c,r)*1.00001;

gtap8.iterlim = 5000;
$include gtap8.gen
solve gtap8 using mcp;
execute_unload "mrtmge_ces_policy_ds=%ds%.gdx";

*$exit
$ontext
set t time period /1*5/;
parameters 
yc_t(i,c,r,t)  yc with time dimension
evom0(f,r)     benchmark evom
vom0(g,r)      benchmark vom
vdfm0(i,g,r)   benchmark vdfm
vifm0(i,g,r)   benchmark vifm
vb0(r)         benchmark vb
;
evom0(f,r) = evom(f,r);
vom0(g,r)  = vom(g,r);
vdfm0(i,g,r) = vdfm(i,g,r);  
vifm0(i,g,r) = vifm(i,g,r);
vb0(r)     = vb(r);

loop(t,

evom(f,r)  = evom0(f,r)*ord(t);
vom("g",r) = vom0("g",r)*ord(t);
vom("i",r) = vom0("i",r)*ord(t);
vdfm(i,"g",r) = vdfm0(i,"g",r)*ord(t);
vifm(i,"i",r) = vifm0(i,"i",r)*ord(t);
vb(r)      = vb0(r)*ord(t); 

gtap8.iterlim = 5000;
$include gtap8.gen
solve gtap8 using mcp;
yc_t(i,c,r,t) = yc.l(i,c,r);

);

execute_unload ".\output\mrtmge_ds=%ds%.gdx";
$offtext

set t time period t /1*1/
parameter counter, step;
counter = 1;
step    = %step%;

loop(t,

* Consumer's price shock:
vdfm("food",c,"usa") = vdfm("food",c,"usa")*(counter+ord(t)*step);
vifm("food",c,"usa") = vifm("food",c,"usa")*(counter+ord(t)*step);

* Endowment shock:
*evom(f,"usa") = evom(f,"usa") *(counter+ord(t)*step);

counter = counter + ord(t)*step;

gtap8.iterlim = 50000;
gtap8.workspace = 50;
gtap8.savepoint = 1;
$include gtap8.gen
solve gtap8 using mcp;
execute_unload ".\output\mrtmge_policy_ds=%ds%_priceshock=%step%.gdx";
);


