$title	Read GTAP8 Basedata and Replicate the Benchmark in MPSGE
* To run the model, type, for example: gams mrtmge_cde --start=0.1 --end=20 --step=0.1

* The following pre-assignment for ds will be used in a $gdxin command in gtap8data.gms
$if not set ds $set ds 2r4s1f

$if not set wt $set wt 0

* Sets, parameters declarations and assignments are done in gtap8data.gms (YHC: 20120614)
$include ..\build\gtap8data

set c(g) private consumption /c/;
set e(g) exogenous consumption /g, i/;

parameters	
esub(g)		Top-level elasticity in demand /C 1/
vcm(i,c,r)      Tax included Armington good i for private consumption,
data(*,*,*)     Output from cdecalib,
cde             CDE calibration,
chkd(i,r)       Check final expenditure D;

* Aggregate final demand (Armington good)
vcm(i,c,r) = vdfm(i,c,r)*(1+rtfd0(i,c,r))+vifm(i,c,r)*(1+rtfi0(i,c,r));

* Read the CDE coefficients
*execute_load ".\input\cdecalib_%ds%_wt=%wt%.gdx" data = data;
execute_load ".\input\cdecalib_%ds%_lnobj.gdx" data = data;
cde(i,r,"alpha")     = data(i,r,"alpha");  
cde(i,r,"e")         = data(i,r,"e");   
cde(i,r,"beta")      = data(i,r,"beta");    
cde("utility",r,"u") = 1;
cde("mc",r,"mc")     = data("mc",r,"mc");

cde(i,r,"alpha")$(cde(i,r,"alpha") eq eps)         = 0;    
cde(i,r,"e")$(cde(i,r,"e") eq eps)             	   = 0;
cde(i,r,"beta")$(cde(i,r,"beta") eq eps)       	   = 0;
cde("utility",r,"u")$(cde("utility",r,"u") eq eps) = 0;
cde("mc",r,"mc")$(cde("mc",r,"mc") eq eps)         = 0;

$ontext
$model:gtap8

$sectors:
	y(g,r)$(not c(g) and vom(g,r))	  ! Supply
	m(i,r)$vim(i,r)		          ! Imports
	yt(j)$vtw(j)		          ! Transportation services
	ft(f,r)$(sf(f) and evom(f,r))	  ! Specific factor transformation
        yc(i,c,r)$vcm(i,c,r)              ! Private consumption by commodity

$commodities:
	p(g,r)$vom(g,r)		          ! Domestic output price	 			 
	pm(j,r)$vim(j,r)		  ! Import price		 		 
	pt(j)$vtw(j)			  ! Transportation services		 
	pf(f,r)$evom(f,r)	          ! Primary factors rent
	ps(f,g,r)$(sf(f) and vfm(f,g,r))  ! Sector-specific primary factors
        pc(i,c,r)$vcm(i,c,r)              ! Private consumption price

$consumers:
	ra(r)			          ! Representative agent

$auxiliary:
        TC(r)                             ! Expenditure for the CDE system
        U(r)                              ! Activity level of Utility
        D(i,r)$vcm(i,"c",r)               ! Activity level of final consumption

* Sectoral output
$prod:y(j,r)$vom(j,r)	s:esub(j)       i.tl:esubd(i)  va:esubva(j)
	o:p(j,r)	q:vom(j,r)	a:ra(r)  t:rto(j,r)
	i:p(i,r)	q:vdfm(i,j,r)	p:(1+rtfd0(i,j,r))   i.tl:  a:ra(r)  t:rtfd(i,j,r)
	i:pm(i,r)	q:vifm(i,j,r)	p:(1+rtfi0(i,j,r))   i.tl:  a:ra(r)  t:rtfi(i,j,r)
	i:ps(sf,j,r)	q:vfm(sf,j,r)	p:(1+rtf0(sf,j,r))   va:    a:ra(r)  t:rtf(sf,j,r)
	i:pf(mf,r)	q:vfm(mf,j,r)	p:(1+rtf0(mf,j,r))   va:    a:ra(r)  t:rtf(mf,j,r)

* Government consumption and investment (exogenous consumption)
$prod:y(e,r)$vom(e,r)	s:esub(e)       i.tl:esubd(i)
	o:p(e,r)	q:vom(e,r)	a:ra(r)  t:rto(e,r)
	i:p(i,r)	q:vdfm(i,e,r)	p:(1+rtfd0(i,e,r))   i.tl:  a:ra(r)  t:rtfd(i,e,r)
	i:pm(i,r)	q:vifm(i,e,r)	p:(1+rtfi0(i,e,r))   i.tl:  a:ra(r)  t:rtfi(i,e,r)

* Private consumption: new
* Level 1: Armington good of commodity i
$prod:yc(i,c,r)$vcm(i,c,r) s:esubd(i)
        o:pc(i,c,r)     q:vcm(i,c,r)                         a:ra(r)  t:rto(c,r)
        i:p(i,r)        q:vdfm(i,c,r)	p:(1+rtfd0(i,c,r))   a:ra(r)  t:rtfd(i,c,r)
        i:pm(i,r)       q:vifm(i,c,r)	p:(1+rtfi0(i,c,r))   a:ra(r)  t:rtfi(i,c,r)

* Level 2: Aggregate various goods to a single consumption good c.  This is where we need to work on for CDE.
* Let's temporarily remove the declaration of y(c,r), and move the sources and sinks in this block to demand block.
* This strategy is similar to linking the top-down and bottom-up. 
* Now this is moved to the representative agent block.

$prod:yt(j)$vtw(j)      s:1
	o:pt(j)		q:vtw(j)
	i:p(j,r)	q:vst(j,r)

$prod:m(i,r)$vim(i,r)	s:esubm(i)      s.tl:0
	o:pm(i,r)	q:vim(i,r)
	i:p(i,s)	q:vxmd(i,s,r)	p:pvxmd(i,s,r)       s.tl:  a:ra(s)  t:(-rtxs(i,s,r))  a:ra(r)  t:(rtms(i,s,r)*(1-rtxs(i,s,r)))
	i:pt(j)#(s)	q:vtwr(j,i,s,r) p:pvtwr(i,s,r)       s.tl:  a:ra(r)  t:rtms(i,s,r)

$prod:ft(sf,r)$evom(sf,r)  t:etrae(sf)
	o:ps(sf,j,r)	q:vfm(sf,j,r)
	i:pf(sf,r)	q:evom(sf,r)

$demand:ra(r)
	d:p("c",r)	q:vom("c",r)
	e:p("c",rnum)	q:vb(r)
	e:p("g",r)	q:(-vom("g",r))
	e:p("i",r)	q:(-vom("i",r))
	e:pf(f,r)	q:evom(f,r)
        e:p(c,r)        q:vom(c,r)      r:U(r)
        e:pc(i,c,r)     q:(-vcm(i,c,r)) r:D(i,r)  

$constraint:TC(r)
        sum(i,cde(i,r,"beta")*(cde("utility",r,"u")*U(r))**(cde(i,r,"e")*(1-cde(i,r,"alpha")))*
        (PC(i,"c",r)/TC(r))**(1-cde(i,r,"alpha"))) =e= 1;   

$constraint:U(r)
        TC(r)*sum(i,cde(i,r,"beta")*cde(i,r,"e")*(1-cde(i,r,"alpha"))*(U(r)**(cde(i,r,"e")*(1-cde(i,r,"alpha"))-1))*(PC(i,"c",r)/TC(r))**(1-cde(i,r,"alpha")))
         =e= data("mc",r,"mc")*P("c",r)*sum(i,cde(i,r,"beta")*(1-cde(i,r,"alpha"))*(U(r)**(cde(i,r,"e")*(1-cde(i,r,"alpha"))))*(PC(i,"c",r)/TC(r))**(1-cde(i,r,"alpha")));

$constraint:D(i,r)$(vcm(i,"c",r))
        vcm(i,"c",r)/vom("c",r)*D(i,r)*sum(j,cde(j,r,"beta")*(U(r)**((1-cde(j,r,"alpha"))*cde(j,r,"e")))*(1-cde(j,r,"alpha"))*(PC(j,"c",r)/TC(r))**(1-cde(j,r,"alpha"))) 
         =e= (cde(i,r,"beta")*(U(r)**((1-cde(i,r,"alpha"))*cde(i,r,"e")))*(1-cde(i,r,"alpha"))*(pc(i,"c",r)/TC(r))**(-cde(i,r,"alpha")));

            
$offtext

$sysinclude mpsgeset gtap8

TC.L(r)   = 1;
TC.LO(r)  = 0.000001;
U.L(r)    = 1;
U.LO(r)   = 0.000001;
D.L(i,r)  = 1;
D.LO(i,r) = 0.000001;
PF.FX("primary","usa") = 1;

gtap8.workspace = 128;
gtap8.iterlim = 0;
$include gtap8.gen
solve gtap8 using mcp;

chkd(i,r) = vcm(i,"c",r)/vom("c",r)*D.L(i,r) 
          - (cde(i,r,"beta")*(U.L(r)**((1-cde(i,r,"alpha"))*cde(i,r,"e")))*(1-cde(i,r,"alpha"))*(PC.L(i,"c",r)/TC.L(r))**(-cde(i,r,"alpha")))
            /sum(j,cde(j,r,"beta")*(U.L(r)**((1-cde(j,r,"alpha"))*cde(j,r,"e")))*(1-cde(j,r,"alpha"))*PC.L(j,"c",r)**(1-cde(j,r,"alpha"))*TC.L(r)**cde(i,r,"alpha"));

execute_unload ".\output\mrtmge_cde_ref_ds=%ds%.gdx";

* The code below is for testing whether the model's realized elasticities equal the calibrated levels it is given to

$if not set step $set step 0
set x shock level /1*%end%/
parameters 
step		step of the shock level, 
start		initial shock coefficient, 
vdfm0		vdfm value from GTAP, 
vifm0		vifm value from GTAP, 
evom0		evom value from GTAP, 
pfx		realized PF with shock level x,
pcx		realized PC over PF with shock level x, 
dx		realized D with shock level x, 
theta_i		final consumption expenditure share, 
eta_i		calibrated income demand point elasticity, 
priexp		total private expenditure,
priexpi		total private expenditure index,
eta_i_a		calibrated average income demand elasticity,
sigma		calibrated AUES price demand elasticity (point elasticity),
delta(i,j,r)	diagonal-one off-diagonal-zero,
sigma_c		calibrated compensated price demand elasticity (point elasticity),
sigma_m		calibrated Marshallian price demand elasticity (point elasticity), 
sigma_ma	calibrated Marshallian price demand elasticity (average elasticity),
dxn		realized D with shock level x net of prices & income effects,
sigma_mar	realized Marshallian price elasticity (average elasticity),
cds		change in d due to changes in other prices,
cdi		change in d due to change in income,
eqi		expected quantity due to pure income effect,
cqp		change in quantity due to change in own-price,
dxi		realized D with shock level x net of prices effects, 
eta_i_ar	realized average income demand elasticity;

alias(i,k);

* Assign start and step in the command line using environment variables
start   = %start%;
step    = %step%;

* Read the shares and calibrated elasticities
theta_i(i,r,"theta")         = data(i,r,"theta");
eta_i(i,r,"etav")	     = data(i,r,"etav");

* Store the original vdfm, vifm, and evom in GTAP
vdfm0(i,c,r) = vdfm(i,c,r);
vifm0(i,c,r) = vifm(i,c,r);
evom0(f,r)   = evom(f,r);

* Step 1: Calculate the Marshallian price demand elasticity (point elasticity)
delta(i,j,r)             = 0;	
delta(i,j,r)$sameas(i,j) = 1;	
sigma(i,j,r)		 = cde(i,r,"alpha")+cde(j,r,"alpha")-sum(k, theta_i(k,r,"theta")*cde(k,r,"alpha"))
			  -delta(i,j,r)*cde(i,r,"alpha")/theta_i(i,r,"theta");
sigma_c(i,j,r)		 = sigma(i,j,r)*theta_i(i,r,"theta");
sigma_m(i,j,r)		 = sigma_c(i,j,r)-eta_i(i,r,"etav")*theta_i(i,r,"theta");

loop(x,

* Consumer's price shock:
vdfm("agri",c,"usa") = vdfm0("agri",c,"usa")*(start+(ord(x)-1)*step);
vifm("agri",c,"usa") = vifm0("agri",c,"usa")*(start+(ord(x)-1)*step);

* Endowment shock:
*evom(f,"usa") = evom0(f,"usa")*(start+(ord(x)-1)*step);

* Avoid raise 0 by a negative number in the third auxiliary equation 
PC.LO(i,"c",r) = 0.000001;

gtap8.iterlim = 50000;
$include gtap8.gen
solve gtap8 using mcp;

* Step 2: Within the loop, derive the calibrated average elasticities associated with the shock

** Marshallian price demand elasticity (average elasticity)
pfx(r,x)   = PF.L("primary",r);
pcx(i,r,x) = PC.L(i,"c",r)/pfx(r,x);
sigma_ma(i,j,r,x)$(pcx(j,r,x) ne 1) = (pcx(j,r,x)**sigma_m(i,j,r)-1)/(pcx(j,r,x)-1)
                                      *(pcx(j,r,x)+1)/(pcx(j,r,x)**sigma_m(i,j,r)+1);
sigma_ma(i,j,r,x)$(pcx(j,r,x) eq 1) = sigma_m(i,j,r);

** Income demand elasticity (average elasticity)
priexp(r,x) = sum(i,pcx(i,r,x)*D.L(i,r)*vcm(i,"c",r));
priexpi(r,x) = priexp(r,x)/sum(i,vcm(i,"c",r));
eta_i_a(i,r,x)$(priexpi(r,x) ne 1) = (priexpi(r,x)**eta_i(i,r,"etav")-1)/(priexpi(r,x)-1)
		*(priexpi(r,x)+1)/(priexpi(r,x)**eta_i(i,r,"etav")+1);
eta_i_a(i,r,x)$(priexpi(r,x) eq 1) = eta_i(i,r,"etav"); 

* Step 3-1: Calculate the substitution effect due to changes in PC-others|original income; after shock PC-own
dx(i,r,x)  = D.L(i,r);
cds(i,r,x) = sum(j$(not sameas(i,j)), (pcx(j,r,x)-1)/((pcx(j,r,x)+1)/2)*sigma_ma(i,j,r,x)*(1+sigma_ma(i,i,r,x)*(pcx(i,r,x)-1)/((1+pcx(i,r,x))/2)*((1+dx(i,r,x))/2)));

* Step 3-2: Calculate the income effect on top of changes in all PC
cdi(i,r,x) = (priexpi(r,x)-1)/((priexpi(r,x)+1)/2)*eta_i_a(i,r,x)*(1+sigma_ma(i,i,r,x)*(pcx(i,r,x)-1)/((1+pcx(i,r,x))/2)+cds(i,r,x));

* Step 3-3: Calculate the adjusted demand net of cross-price effect and income effect
dxn(i,r,x) = dx(i,r,x)-cds(i,r,x)-cdi(i,r,x);
sigma_mar(i,j,r,x)$(pcx(j,r,x) ne 1) = (dxn(i,r,x)-1)/((dxn(i,r,x)+1)/2) / ((pcx(j,r,x)-1)/((pcx(j,r,x)+1)/2));

* Step 3-4: Calculate expected quantity level due to pure income effect
eqi(i,r,x) = (priexpi(r,x))**eta_i(i,r,"etav");

* Step 3-5: Based on the expected quantity derived from pure income effect, calculate the quantity changes due to changes in prices
cqp(i,r,x) = sum(j, (pcx(j,r,x)-1)/((pcx(j,r,x)+1)/2)*sigma_ma(i,j,r,x)*eqi(i,r,x));

* Step 3-6: Substract quantity change due to price effect from the observed quantity
dxi(i,r,x) = dx(i,r,x) - cqp(i,r,x);

* Step 3-7: Calculate the realized income demand elasticity
eta_i_ar(i,r,x) = (dxi(i,r,x)-1)/((dxi(i,r,x)+1)/2)/((priexpi(r,x)-1)/((priexpi(r,x)+1)/2));

execute_unload ".\output\mrtmge_cde_policy_ds=%ds%_priceshock=%step%.gdx";
*execute_unload ".\output\mrtmge_cde_policy_ds=%ds%_incomeshock=%step%.gdx";

);










