devtools::install_github('mivanic/HARr')
devtools::install_github('mivanic/tabloToR')

rm(list=ls())

model = tabloToR::GEModel$new()

model$loadTablo('gtap.tab')

data = list(
  gtapsets = HARr::read_har('gsdgset.har'),
  gtapparm = HARr::read_har('gsdgpar.har'),
  gtapdata = HARr::read_har('gsdgdat.har')
)


model$loadData(data)

for(var in c("afall",
      "afcom",
      "afeall",
      "afecom",
      "afereg",
      "afesec",
      "afreg",
      "afsec",
      "ams",
      "aoall",
      "aoreg",
      #'qgdp',
      "aosec",
      "atall",
      "atd",
      "atf",
      "atm",
      "ats",
      "au",
      "avaall",
      "avareg",
      "avasec",
      "cgdslack",
      "dpgov",
      "dppriv",
      "dpsave",
      "endwslack",
      "incomeslack",
      "pfactwld",
      "pop",
      "profitslack",
      "psaveslack",
      #"qo(ENDW_COMM,REG)",
      "tf",
      "tfd",
      "tfm",
      "tgd",
      "tgm",
      "tm",
      "tms",
      "to",
      "tpd",
      "tpm",
      "tp",
      "tradslack",
      "tx",
      "txs")){
  model$variableValues[[var]][]=0
}

model$variableValues$qo[model$data$endw_comm,] = 0


ag= c("grains", "v_f", "osd", "c_b", "pfb", "ocr", "ctl", "oap", "rmk", "wol")
model$variableValues$aoall[ag,c("northam")] = 1

agFood = c("grains", "v_f", "osd", "c_b", "pfb", "ocr", "ctl", "oap", "rmk", "wol", "food")

model$variableValues$tms[agFood,,c("northam")] = (model$data$viws[agFood,,c("northam")] / model$data$vims[agFood,,c("northam")] -1)*100

tictoc::tic()
model$solveModel(iter = 3,steps = c(1,3))
tictoc::toc()


model$data$qgdp
